// Header Nav Mobile

$(".header-nav__btn").on("click", function () {
  let classes = window.matchMedia("(min-width: 992px)").matches
    ? ".header-nav__icon, .header-nav"
    : ".header-nav__icon, .header-nav";
  $(classes).toggleClass("opened");
});

$(window).on("resize", function () {
  $(".header-nav__icon, .header-nav").removeClass("opened");
});

// Padding Left Adjustment

const paddingLeftAdjustment = () => {
  let containerWidth = $(".container").outerWidth();
  let bodyWidth = $("body").outerWidth();
  $(".padding-left-adj").css(
    "padding-left",
    `${(bodyWidth - containerWidth) / 2}px`
  );
};

paddingLeftAdjustment();

$(window).on("resize", function () {
  paddingLeftAdjustment();
});

// Owl Carousel

$(function () {
  $(".owl-carousel.banner-carousel").owlCarousel({
    animateOut: "fadeOut",
    dots: true,
    nav: false,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    loop: true,
    items: 1,
    margin: 0,
    autoplay: true,
    autoplayTimeout: 7000,
    autoplayHoverPause: true,
    touchDrag: false,
    mouseDrag: false,
    responsive: {
      768: {
        nav: true,
      },
    },
  });

  $(".owl-carousel.home-categories__carousel").owlCarousel({
    dots: false,
    nav: true,
    loop: false,
    rewind: true,
    items: 4,
    margin: 20,
    autoplay: true,
    autoplayTimeout: 7000,
    autoplayHoverPause: true,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    responsive: {
      0: {
        items: 1,
      },
      576: {
        items: 2,
      },
      768: {
        items: 4,
      },
    },
  });

  $(".owl-carousel.product-variations__carousel").owlCarousel({
    dots: false,
    nav: true,
    loop: false,
    rewind: true,
    items: 4,
    margin: 20,
    autoplay: true,
    autoplayTimeout: 7000,
    autoplayHoverPause: true,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
    responsive: {
      0: {
        items: 1,
      },
      576: {
        items: 2,
      },
      768: {
        items: 4,
      },
    },
  });

  $(".owl-carousel.categories-carousel").owlCarousel({
    dots: false,
    nav: true,
    loop: false,
    rewind: true,
    autoWidth: true,
    stagePadding: 40,
    // items: 6,
    margin: 20,
    autoplay: true,
    autoplayTimeout: 7000,
    autoplayHoverPause: true,
    navText: [
      "<i class='fas fa-chevron-left'></i>",
      "<i class='fas fa-chevron-right'></i>",
    ],
  });

  /* Single Product Gallery Carousel Sync */
  $(document).ready(function () {
    var sync1 = $("#sync1");
    var sync2 = $("#sync2");
    var slidesPerPage = 4; //globaly define number of elements per page
    var syncedSecondary = true;

    sync1
      .owlCarousel({
        items: 1,
        slideSpeed: 2000,
        nav: true,

        autoplay: false,
        dots: false,
        loop: false,
        responsiveRefreshRate: 200,
        navText: [
          "<i class='fas fa-chevron-left'></i>",
          "<i class='fas fa-chevron-right'></i>",
        ],
      })
      .on("changed.owl.carousel", syncPosition);

    sync2
      .on("initialized.owl.carousel", function () {
        sync2.find(".owl-item").eq(0).addClass("current");
      })
      .owlCarousel({
        items: slidesPerPage,
        dots: false,
        nav: false,
        margin: 20,
        smartSpeed: 200,
        slideSpeed: 500,
        slideBy: slidesPerPage, //alternatively you can slide by 1, this way the active slide will stick to the first item in the second carousel
        responsiveRefreshRate: 100,
        navText: [
          "<i class='fas fa-chevron-left'></i>",
          "<i class='fas fa-chevron-right'></i>",
        ],
      })
      .on("changed.owl.carousel", syncPosition2);

    function syncPosition(el) {
      //if you set loop to false, you have to restore this next line
      var current = el.item.index;

      //if you disable loop you have to comment this block
      // var count = el.item.count - 1;
      // var current = Math.round(el.item.index - el.item.count / 2 - 0.5);

      // if (current < 0) {
      //   current = count;
      // }
      // if (current > count) {
      //   current = 0;
      // }

      //end block

      sync2
        .find(".owl-item")
        .removeClass("current")
        .eq(current)
        .addClass("current");
      var onscreen = sync2.find(".owl-item.active").length - 1;
      var start = sync2.find(".owl-item.active").first().index();
      var end = sync2.find(".owl-item.active").last().index();

      if (current > end) {
        sync2.data("owl.carousel").to(current, 100, true);
      }
      if (current < start) {
        sync2.data("owl.carousel").to(current - onscreen, 100, true);
      }
    }

    function syncPosition2(el) {
      if (syncedSecondary) {
        var number = el.item.index;
        sync1.data("owl.carousel").to(number, 100, true);
      }
    }

    sync2.on("click", ".owl-item", function (e) {
      e.preventDefault();
      var number = $(this).index();
      sync1.data("owl.carousel").to(number, 300, true);
    });
  });
  /* End Single Product Gallery Carousel Sync */

  //AOS
  // AOS.init({
  //   duration: 1000,
  // });

  // Header Nav Link padding adjustment

  const header = document.querySelector(".header");
  $(window).on("scroll", function () {
    if (window.matchMedia("(min-width: 992px)").matches) {
      if (window.scrollY > 0) {
        header.classList.add("scrolled");
      } else {
        header.classList.remove("scrolled");
      }
    } else {
      header.classList.remove("scrolled");
    }
  });

  /* Segments change */

  let segmentsList = document.querySelectorAll(".segments-item");
  let segmentsImageList = document.querySelectorAll(".segments-items__image");

  segmentsList.forEach((segmentItem, i, arr) => {
    segmentItem.addEventListener("click", function () {
      arr.forEach((i) => {
        i.classList.remove("active");
      });
      this.classList.add("active");
      let dataSegmentItem = this.dataset.segmentItem;

      segmentsImageList.forEach((segmentsImage) => {
        segmentsImage.classList.remove("active");
        if (dataSegmentItem == segmentsImage.dataset.segmentImage) {
          segmentsImage.classList.add("active");
        }
      });
    });
  });

  /* Phone Mask */

  $("#phone").mask("(00) 0000-00009");

  $("#phone").on("keyup", function () {
    if ($("#phone").val().length <= 14) {
      $("#phone").mask("(00) 0000-00009");
    } else {
      $("#phone").mask("(00) 00000-0000");
    }
  });

  // Search Btn

  $(".header-search__btn").on("click", function () {
    $(".header-search__form").toggleClass("show");
    if ($(this).html().trim() === '<i class="fas fa-magnifying-glass"></i>') {
      $(this).html('<i class="fas fa-close"></i>');
    } else {
      $(this).html('<i class="fas fa-magnifying-glass"></i>');
    }
    setTimeout(function () {
      $("#search-input").focus();
    }, 200);
  });

  // Megamenu Behavior

  let megamenuParentItems = document.querySelectorAll(".megamenu-parent-item");
  let megamenuChildrenItems = document.querySelectorAll(".megamenu-child-item");

  megamenuParentItems?.forEach((parentItem, i, arr) => {
    let parentId = parentItem.dataset.parentCategory;
    parentItem.addEventListener("mouseover", function () {
      arr.forEach((i) => {
        i.classList.remove("active");
      });
      parentItem.classList.add("active");
      megamenuChildrenItems?.forEach((childItem) => {
        childItem.classList.add("d-none");
        let childId = childItem.dataset.childCategory;
        if (childId === parentId) {
          childItem.classList.remove("d-none");
        }
      });
    });
  });

  // Smooth Scroll Options
  SmoothScroll({ animationTime: 600 });

  // Scroll Animation
  AOS.init({
    duration: 800,
    disable: "tablet",
  });

  // Lighthouse Adjustments

  $(".owl-dot").each(function () {
    $(this).attr({ title: "Botão" });
  });
  $(".owl-next").each(function () {
    $(this).attr({ title: "Próximo" });
  });
  $(".owl-prev").each(function () {
    $(this).attr({ title: "Anterior" });
  });

  $(".lb-prev, .lb-next, .lb-close, .lb-cancel").attr({ href: "#" });
});
