<?php

require get_template_directory() . '/functions/cpts.php';
// require get_template_directory() . '/functions/config.php';
// require get_template_directory() . '/functions/google-tags.php';
require get_template_directory() . '/functions/load-scripts.php';

function theme_config()
{
    register_nav_menus(
        array(
            'my_main_menu' => __('Main Menu', 'theme')
        )
    );

    add_theme_support('post-thumbnails');
    add_theme_support(
        'post-formats',
        array('video', 'image', 'gallery')
    );
    add_theme_support('title-tag');
    add_theme_support(
        'custom-logo',
        array('height' => 72, 'width' => 356)
    );
}
add_action('after_setup_theme', 'theme_config', 0);

// add_action("categoria-produtos_edit_form_fields", 'remove_description_field', 10, 2);

function remove_description_field($term, $taxonomy)
{
    ?>

    <script>
        jQuery(window).ready(function () {
            jQuery('label[for=description]').parent().parent().remove();
        });
    </script>
    <?php
}

// add_action('after_setup_theme', 'remove_admin_bar');
function remove_admin_bar()
{
    show_admin_bar(false);
}

add_filter('wpcf7_autop_or_not', '__return_false');

function my_favicon()
{ ?>
    <link rel="shortcut icon" href="<? print get_template_directory_uri(); ?>/assets/images/favicon.png">
    <link rel="apple-touch-icon" href="<? print get_template_directory_uri(); ?>/assets/images/favicon.png">
<?php }
add_action('wp_head', 'my_favicon');

/* Product Query Vars */

// function add_custom_query_var($vars)
// {
//     $vars[] = "product";
//     $vars[] = "measure";
//     $vars[] = "measure_type";
//     return $vars;
// }
// add_filter('query_vars', 'add_custom_query_var');