<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  <header class="header">
    <div class="header-logo">
      <a href="<?php bloginfo('url'); ?>">
        <img src="<?php bloginfo('template_url'); ?>/assets/images/logo.svg" alt="">
      </a>
    </div>
    <nav class="header-nav">
      <ul class="header-nav__list">
        <li>
          <a href="#">Home</a>
        </li>
        <li>
          <a href="#">Produtos</a>
          <ul class="header-nav__sublist">
            <li>
              <a href="#">Produto Teste</a>
            </li>
            <li>
              <a href="#">Produto Teste</a>
            </li>
            <li>
              <a href="#">Produto Teste</a>
            </li>
          </ul>
        </li>
        <li>
          <a href="#">Projetos</a>
          <ul class="header-nav__sublist">
            <li>
              <a href="#">Projeto Teste</a>
            </li>
            <li>
              <a href="#">Projeto Teste</a>
            </li>
            <li>
              <a href="#">Projeto Teste</a>
            </li>
          </ul>
        </li>
        <li>
          <a href="#">Blog</a>
        </li>
        <li>
          <a href="#">Contato</a>
        </li>
      </ul>
    </nav>
    <div class="header-nav__btn">
      <div class="header-nav__icon">
        <div class="header-nav__icon-bar header-nav__icon-bar--1"></div>
        <div class="header-nav__icon-bar header-nav__icon-bar--2"></div>
        <div class="header-nav__icon-bar header-nav__icon-bar--3"></div>
      </div>
    </div>
    <!-- <?php wp_nav_menu(
      array(
        'theme_location' => 'my_main_menu',
        'container' => 'nav',
        'container_class' => 'header-nav',
        'menu_class' => 'header-nav__list'
      )
    );
    ?> -->
    <div class="header-contact">
      <a href="#" class="header-contact__item" target="_blank" rel="noopener">
        <img class="header-contact__icon" src="<?php bloginfo('template_url'); ?>/assets/images/icon-whatsapp.png"
          alt="WhatsApp Icon">
        <span>(11) 94776-7302</span>
      </a>
      <div class="header-contact__social social">
        <a href="#" rel="noopener" target="_blank" class="social__item" title="Instagram">
          <i class="social__icon  fab fa-instagram"></i>
        </a>
        <a href="#" rel="noopener" target="_blank" class="social__item" title="Facebook">
          <i class="social__icon fab fa-facebook"></i>
        </a>
        <!-- <a href="#" rel="noopener" target="_blank" class="social__item" title="LinkedIn">
          <i class="social__icon icon fab fa-linkedin-in"></i>
        </a> -->
      </div>
    </div>
  </header>
  <div class="header-placeholder"></div>
  <a href="#" class="fixed-whatsapp" target="_blank" rel="noopener" title="WhatsApp">
    <i class="fab fa-whatsapp"></i>
  </a>
  <main>