<?php
get_header();

$args = array(
  'post_type' => 'product',
  'posts_per_page' => -1,
  's' => $s
);

$products = get_posts($args);

?>
<div class="search search-page">
  <div class="container">
    <div class="search-header">
      <h1 class="title">Resultados de busca: <?php echo $s; ?></h1>
    </div>
    <?php if ($products): ?>

      <div class="category-grid">
        <?php foreach ($products as $post):
          setup_postdata($post);
          $category = get_the_terms(get_the_ID(), 'product_cat')[0]
            ?>
          <a href="<?php the_permalink(); ?>" class="products-item">
            <div class="products-item__image">
              <!-- <img src="<?php bloginfo('template_url'); ?>/assets/images/lixeira.jpg" alt="Lixeiras"> -->
              <?php the_post_thumbnail('large'); ?>
            </div>
            <div class="products-item__text">
              <span class="products-item__category">
                <?php echo $category->name; ?>
              </span>
              <h3 class="products-item__name"><?php the_title(); ?></h3>
              <button type="button" class="btn btn--white btn--bg-orange">Ver mais</button>
            </div>
          </a>
          <?php
          wp_reset_postdata();
        endforeach;
        ?>
      </div>

    <?php else: ?>
      <div class="my-5">
        <p>Nenhum item encontrado.</p>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php
get_footer();
?>