<?php

function load_scripts()
{
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/inc/bootstrap/css/bootstrap.min.css', array(), '5.1.3', 'all');
    wp_enqueue_style('lightbox', get_template_directory_uri() . '/inc/lightbox/css/lightbox.min.css', array(), '2.11.3', 'all');
    wp_enqueue_style('fontawesome-brands', get_template_directory_uri() . '/inc/fontawesome/css/brands.min.css', array(), '6.1.1', 'all');
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/inc/fontawesome/css/fontawesome.min.css', array(), '6.1.1', 'all');
    wp_enqueue_style('fontawesome-regular', get_template_directory_uri() . '/inc/fontawesome/css/regular.min.css', array(), '6.1.1', 'all');
    wp_enqueue_style('fontawesome-solid', get_template_directory_uri() . '/inc/fontawesome/css/solid.min.css', array(), '6.1.1', 'all');
    wp_enqueue_style('owlcarousel', get_template_directory_uri() . '/inc/owlcarousel/css/owl.carousel.min.css', array(), '2.3.4', 'all');
    wp_enqueue_style('owlcarousel-theme-default', get_template_directory_uri() . '/inc/owlcarousel/css/owl.theme.default.min.css', array(), '2.3.4', 'all');
    wp_enqueue_style('montserrat-font-family', get_template_directory_uri() . '/assets/fonts/montserrat-font-family/stylesheet.css', array(), '1.0.0', 'all');
    wp_enqueue_style('animate', get_template_directory_uri() . '/inc/animate/animate.min.css', array(), '4.1.1', 'all');
    wp_enqueue_style('main', get_template_directory_uri() . '/assets/css/main.css', array(), '1.0.0', 'all');
    wp_enqueue_style('media-queries', get_template_directory_uri() . '/assets/css/media-queries.css', array(), '1.0.0', 'all');

    wp_enqueue_script('jquery-3.6.0', get_template_directory_uri() . '/inc/jquery/jquery-3.6.0.min.js', array(), '3.6.0', true);
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/inc/bootstrap/js/bootstrap.min.js', array(), '5.1.3',  true);
    wp_enqueue_script('lightbox', get_template_directory_uri() . '/inc/lightbox/js/lightbox.min.js', array(), '2.11.3',  true);
    wp_enqueue_script('owlcarousel', get_template_directory_uri() . '/inc/owlcarousel/js/owl.carousel.min.js', array(), '2.3.4',  true);
    wp_enqueue_script('rellax', get_template_directory_uri() . '/inc/rellax/rellax.min.js', array(), '1.0.0',  true);
    wp_enqueue_script('jquery-mask-plugin', get_template_directory_uri() . '/inc/jquery-mask-plugin/dist/jquery.mask.min.js', array(), '1.14.16',  true);
    wp_enqueue_script('scrollreveal', get_template_directory_uri() . '/inc/scrollreveal/scrollreveal.min.js', array(), '1.14.16',  false);
    wp_enqueue_script('scripts-site', get_template_directory_uri() . '/assets/js/scripts-site.js', array(), '1.0.0', true);
}

add_action('wp_enqueue_scripts', 'load_scripts');

function status_config()
{
  register_nav_menus(
    array(
      'my_main_menu' => __('Main Menu', 'status')
    )
  );

  add_theme_support('post-thumbnails');
  add_theme_support(
    'post-formats',
    array('video', 'image', 'gallery')
  );
  add_theme_support('title-tag');
  add_theme_support(
    'custom-logo',
    array('height' => 72, 'width' => 356)
  );
}
add_action('after_setup_theme', 'status_config', 0);

function my_favicon()
{ ?>
  <link rel="shortcut icon" href="<? print get_template_directory_uri(); ?>/assets/images/icons/favicon.png">
  <link rel="apple-touch-icon" href="<? print get_template_directory_uri(); ?>/assets/images/favicon-plataformanet-512x512.png">
<?php }
//add_action('wp_head', 'my_favicon');

/* Tags */

// add_action('wp_head','my_analytics', 20);
// add_action('wp_head','my_tagmanager_head', 0);
// add_action('wp_body_open','my_tagmanager_body', 0);
	
function my_analytics(){
	?>
	<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-228257415-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-228257415-1');
</script>
	<?php
}

function my_tagmanager_head(){
	?>
		<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-KXHHKXS');</script>
<!-- End Google Tag Manager -->

	<?php
}

function my_tagmanager_body(){
	?>
		<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-KXHHKXS"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<?php
}