jQuery(document).ready(function ($) {

 function splideCarrousel(){
    if ($('#product-thumbnail-carousel').length > 0) {
        let main = new Splide('#product-main-carousel', {
            type: 'fade',
            rewind: true,
            pagination: false,
            arrows: false,
        });

        let thumbnails = new Splide('#product-thumbnail-carousel', {
            // fixedWidth: 100,
            fixedHeight: 100,
            perPage: 3,
            gap: 10,
            rewind: true,
            pagination: false,
            isNavigation: true,
            arrows: false,
            breakpoints: {
                600: {
                    fixedWidth: 60,
                    fixedHeight: 44,
                },
            },
        });

        main.sync(thumbnails);
        main.mount();
        thumbnails.mount();
    }
 }   

$('.patterns-item').each(function(index){
    jQuery('#ver-mais-'+index).on('click', function () {

        window.scrollTo(0,200);

        let url = $('.patterns-item').data('url');

        let idProduto = $('.patterns-item').data('id-produto');

        idPadraoTextura = $("#padrao-textura-"+index).data("id-padrao-textura");
        padraoTextura = $("#padrao-textura-"+index).data("padrao-textura");

        let galeria = [];
        $('.galeria-'+index).each(function(){
            galeria.push($(this).attr('data-galeria-url'));
        });
        
        let dados = {
            'action': 'acao_troca_galeria_e_textura',
            'dados':
            padraoTextura + ";" +
            galeria + ";" +
            idPadraoTextura
        };
        
        
        $.post(ajax_object.ajax_url, dados, function (resposta) {
            
        let $div_galeria = jQuery('.mostra-galeria');
        let $div_textura_padrao = jQuery('.mostra-padrao-textura');
    
        $div_galeria.html(resposta.galeria);
        $div_textura_padrao.html(resposta.padrao_textura); 

        let urlOrcamento = url + '/orcamento?action=addToCart&id_produto='+idProduto+'&id_padrao_textura='+idPadraoTextura;

        $('.add-cart').attr("data-id-padrao-textura", idPadraoTextura);
        
        splideCarrousel();
        
    }, 'json');
    return false;
    
   });

});

});

jQuery('#loading').hide()

jQuery(document).on({
	ajaxStart: function () { jQuery('#loading').show(); },
	ajaxStop: function () { jQuery('#loading').fadeOut('fast'); }
});