jQuery(document).ready(function ($) {
    {
        let x = 0;
        $('.header-nav__btn').on('click', function () {
            if (x === 0) {
                $('.header-nav__icon, .header-nav').addClass('opened')
                x = 1
            } else {
                $('.header-nav__icon, .header-nav').removeClass('opened')
                x = 0
            }
        })
    }

    let bodyWidth = $('body').width()
    let containerWidth = $('.container').width()
    let divPadding = (bodyWidth - containerWidth) / 2
    $('.projects-content').css('padding-right', `${divPadding}px`)
    $('.products-categories, .patterns-items').css('padding-left', `${divPadding}px`)

    $(window).on('resize', function () {
        bodyWidth = $('body').width()
        containerWidth = $('.container').width()
        divPadding = (bodyWidth - containerWidth) / 2
        $('.projects-content').css('padding-right', `${divPadding}px`)
        $('.products-categories, .patterns-items').css('padding-left', `${divPadding}px`)
    })

    $('.sidebar-collapse-btn').on('click', function (e) {
        e.preventDefault();
        console.log('ok');
    })

    /* Owl carousel sliders */

    $(".owl-carousel.banner__carousel").owlCarousel({
        // animateOut: 'animate__slideOutDown',
        // animateIn: 'animate__backInDown',
        dots: true,
        loop: false,
        nav: false,
        items: 1,
        autoHeight: true,
        mouseDrag: false,
        touchDrag: false,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: false,
        smartSpeed: 1000,
    });

    $(".owl-carousel.projects-carousel").owlCarousel({
        // animateOut: 'animate__slideOutDown',
        // animateIn: 'animate__backInDown',
        dots: true,
        loop: false,
        nav: false,
        items: 1,
        autoHeight: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        smartSpeed: 1000
    });

    $(".owl-carousel.products-carousel").owlCarousel({
        // animateOut: 'animate__slideOutDown',
        // animateIn: 'animate__backInDown',
        dots: true,
        loop: false,
        nav: false,
        items: 1,
        autoHeight: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        smartSpeed: 1000
    });

    $(".owl-carousel.lista-produtos-carousel").owlCarousel({
        // animateOut: 'animate__slideOutDown',
        // animateIn: 'animate__backInDown',
        dots: false,
        loop: false,
        nav: false,
        margin: 20,
        autoWidth: true,
        autoHeight: true,
        autoplay: false,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        smartSpeed: 1000
    });


    /* Splide Product Slider */

    if ($('#product-thumbnail-carousel').length > 0) {
        let main = new Splide('#product-main-carousel', {
            type: 'fade',
            rewind: true,
            pagination: false,
            arrows: false,
        });

        let thumbnails = new Splide('#product-thumbnail-carousel', {
            // fixedWidth: 100,
            fixedHeight: 100,
            perPage: 3,
            gap: 10,
            rewind: true,
            pagination: false,
            isNavigation: true,
            arrows: false,
            breakpoints: {
                600: {
                    fixedWidth: 60,
                    fixedHeight: 44,
                },
            },
        });

        main.sync(thumbnails);
        main.mount();
        thumbnails.mount();
    }

    /**
     * Script para fazer aparecer o botão de saber mais
     * no bloco de produtos
     */

    $('.lista__itens .col-md-4').each(function(index){
        $('.effect__mouse-'+index).on('mouseover', function(){ 
            $('#bloco__item-'+index).attr('class','add__bloco--item');
            $('#title__item-'+index).attr('class','add__title--item');
        });
    
        $('.effect__mouse-'+index).on('mouseout', function(){
            $('#bloco__item-'+index).attr('class','bloco__item');
            $('#title__item-'+index).attr('class','title__item');
        });
    });


    /* End Owl carousel sliders */

    /* Phone Mask */

    $('.phone-field input').mask('(00) 0000-00009');

    $('.phone-field input').on('keyup', function () {
        if ($('.phone-field input').val().length <= 14) {
            $('.phone-field input').mask('(00) 0000-00009');
        } else {
            $('.phone-field input').mask('(00) 00000-0000');
        }   
    });

    $(window).on('load', function () {
        $('#loader').fadeOut();
        $('#preloader').delay(550).fadeOut('slow');
    })

})