<?php
function magnus_config()
{
  register_nav_menus(
    array(
      'my_main_menu' => __('Main Menu', 'magnus')
    )
  );

  add_theme_support('post-thumbnails');
  add_theme_support(
    'post-formats',
    array('video', 'image', 'gallery')
  );
  add_theme_support('title-tag');
  add_theme_support(
    'custom-logo',
    array('height' => 72, 'width' => 356)
  );
}
add_action('after_setup_theme', 'magnus_config', 0);

if (function_exists('acf_add_options_page')) {

  acf_add_options_page(array(
    'page_title'   => 'Gestão de Banners Home',
    'menu_title'  => 'Gestão de Banners Home',
    'menu_slug'   => 'theme-banners-home',
    'capability'  => 'edit_posts',
    'redirect'    => false,
    'icon_url' => 'dashicons-images-alt',
    'position' => 3
  ));
}

add_image_size('banner', 1920, 440, true); // 1920x440


function sess_start()
{
  if (!session_id())
    session_start();
}
add_action('init', 'sess_start');
