<?php

/**
 * Custom post types
 */
function my_post_type()
{
    /**
     * Produtos
     */
    register_post_type(
        'produtos',
        array(
            'labels' => array(
                'name' => __('Produtos'),
                'singular_name' => __('Produto')
            ),
            'taxonomies' => array('produtos-category'),
            'public' => true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-products',
            'show_in_rest' => true,
            'supports' => array('title', 'thumbnail', 'editor'),
        )
    );

    /**
     * Projetos
     */
    register_post_type(
        'projetos',
        array(
            'labels' => array(
                'name' => __('Projetos'),
                'singular_name' => __('Projeto')
            ),
            'public' => true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-format-image',
            'show_in_rest' => true,
            'supports' => array('title', 'thumbnail', 'editor'),
        )
    );

    /**
     * Serviços
     */
    register_post_type(
        'servicos',
        array(
            'labels' => array(
                'name' => __('Serviços'),
                'singular_name' => __('Serviço')
            ),
            'public' => true,
            'has_archive' => true,
            'menu_icon' => 'dashicons-admin-tools',
            'show_in_rest' => true,
            'supports' => array('title', 'thumbnail', 'editor'),
        )
    );
}

$labels = array(
    'name' => _x('Categorias', 'taxonomy general name'),
    'singular_name' => _x('Categoria', 'taxonomy singular name'),
    'search_items' =>  __('Procurar categoria'),
    'all_items' => __('Todos'),
    'edit_item' => __('Editar categoria'),
    'update_item' => __('Editar categoria'),
    'add_new_item' => __('Adicionar categoria'),
    'new_item_name' => __('Nova categoria')
);

register_taxonomy('produtos-category', array('produtos'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'query_var' => true,
    'show_in_nav_menus' => true,
    'show_in_rest' => true,
    'rewrite' => array('slug' => 'categoria-produtos', 'with_front' => false),
));

register_taxonomy('projetos-category', array('projetos'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'query_var' => true,
    'show_in_nav_menus' => true,
    'show_in_rest' => true,
    'rewrite' => array('slug' => 'categoria-projetos', 'with_front' => false),
));

add_action('init', 'my_post_type');
