<?
$args = array(
    'post_type' => 'projetos',
    'posts_per_page' => 12,
    'orderby' => 'date',
    'order' => 'desc',
);

$query_posts = get_posts($args);

$queryResults = new WP_Query($args);

$maxPages = $queryResults->max_num_pages;
?>

<div class="main">
    <section class="sidebar">
        <? get_template_part('templates/content', 'sidebar'); ?>
    </section>

    <section class="content">

        <div class="wrap__content">

            <nav aria-label="breadcrumb" class="breadcrumb__product">
                <div class="row">
                    <div class="col-md-12">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<? bloginfo('url'); ?>">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Projetos</li>
                        </ol>
                    </div>
                </div>
            </nav>

            <section class="project loadmore">

                <div id="loading" class="loading-layer">
                    <div class="lds-ring">
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                    </div>
                </div>

                <div class="content__projects">
                    <h1>Nossos Projetos</h1>
                    <div class="col-md-12">
                        <div class="row lista__itens post_type" data-post-type="projetos">
                            <?
                            foreach ($query_posts as $key => $p) {
                                setup_postdata(($p));
                                $caminho_da_imagem = get_the_post_thumbnail_url($p->ID, 'large');
                            ?>
                                <div class="col-md-4 effect__mouse-<?= $key ?> pagination-post" data-pagination="<?= $maxPages ?>">
                                    <a href="<?= get_permalink($p->ID); ?>">
                                        <div class="bloco__item" id="bloco__item-<?= $key ?>">
                                            <div class="bloco__project">
                                                <img src="<?= $caminho_da_imagem; ?>" alt="<?= $p->post_title; ?>">
                                            </div>
                                            <h2><?= $p->post_title; ?></h2>
                                            <p><?= get_the_excerpt($p->ID); ?></p>
                                        </div>
                                    </a>
                                    <div class="title__item" id="title__item-<?= $key ?>">
                                        <h2><?= $p->post_title; ?></h2>
                                        <button><a href="<?= get_permalink($p->ID); ?>">Saber mais</a></button>
                                    </div>
                                </div>
                            <?
                            }
                            wp_reset_postdata();
                            ?>
                        </div>


                    </div>
                </div>

                <div class="content__projects more-posts">
                    <div class="col-md-12">
                        <div class="row">

                        </div>
                    </div>
                </div>

                <?
                if ($maxPages > 1) {
                ?>

                    <div class="btn__ver--mais" id="loadmore-btn">
                        <button>Ver mais</button>
                    </div>
                <?
                }
                ?>
            </section>
        </div>
    </section>

</div>