<?php
require get_template_directory() . '/widgets/widgets.php';

//Carregando nossos scripts e folhas de estilos
function load_scripts(){
    //css
    wp_enqueue_style('fontawesome-css', get_template_directory_uri().'/css/fontawesome/fontawesome.min.css', array(), '5.13.0', 'all');
    wp_enqueue_style('brands-css', get_template_directory_uri().'/css/fontawesome/brands.css', array(), '5.13.0', 'all');
    wp_enqueue_style('solid-css', get_template_directory_uri().'/css/fontawesome/solid.css', array(), '5.13.0', 'all');
    wp_enqueue_style('owl-carousel-css', get_template_directory_uri().'/css/owl.carousel.min.css', array(), '2.3.4', 'all');
    wp_enqueue_style('owl-theme-css', get_template_directory_uri().'/css/owl.theme.default.min.css', array(), '2.3.4', 'all');
    wp_enqueue_style('bootstrap-css', get_template_directory_uri().'/css/bootstrap.min.css', array(), '4.5.2', 'all');
    wp_enqueue_style('animate', get_template_directory_uri().'/css/animate.css', array(), '4.5.2', 'all');
    wp_enqueue_style('gotham-font-family-css', get_template_directory_uri().'/css/gotham-font-family/stylesheet.css', array(), '1.0', 'all');
    wp_enqueue_style('estilo-css', get_template_directory_uri().'/css/estilo-base.css', array(), '1.0', 'all');
    wp_enqueue_style('media-queries-css', get_template_directory_uri().'/css/media-queries.css', array(), '1.0', 'all');
    wp_enqueue_style('masterslider-css', get_template_directory_uri().'/css/masterslider.main.css', array(), '1.0', 'all');
    /*if(is_product()){
        wp_enqueue_style('masterslider-css', get_template_directory_uri().'/css/masterslider.main.css', array(), '1.0', 'all');
    }*/

    //scripts
    wp_enqueue_script('jquery-js', get_template_directory_uri().'/js/jquery-3.5.1.min.js', array(), '3.5.1', true);
    wp_enqueue_script('popper-js', get_template_directory_uri().'/js/popper.min.js', array(), '3.5.1', true);
    wp_enqueue_script('bootstrap-js', get_template_directory_uri().'/js/bootstrap.min.js', array(), '4.5.2', true);
    wp_enqueue_script('owl.carousel-js', get_template_directory_uri().'/js/owl.carousel.min.js', array(), '2.3.4', true);
    wp_enqueue_script('owlcarousel-home-js', get_template_directory_uri().'/js/owlcarousel-home.js', array(), '1.0', true);
    wp_enqueue_script('topo-responsivo-js', get_template_directory_uri().'/js/topo-responsivo.js', array(), '1.0', true);
    wp_enqueue_script('funcao-troca-produto-ajax-js', get_template_directory_uri().'/js/funcao-troca-produto-ajax.js', array(), '1.0', true);
     wp_localize_script('funcao-troca-produto-ajax-js', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
    wp_enqueue_script('funcao-disposicao-js', get_template_directory_uri().'/js/funcao-disposicao.js', array(), '1.0', true);
    wp_enqueue_script('master-slider', get_template_directory_uri().'/js/masterslider.js', array(), '2.50.0', true);
    wp_enqueue_script('funcao-master-slider', get_template_directory_uri().'/js/funcao-masterslider.js', array(), '1.0', true);
   // wp_enqueue_script('jquery-mask', get_template_directory_uri().'/js/jquery-mask-plugin/dist/jquery.mask.min.js', array(), '1.14.10', true);
    //wp_enqueue_script('funcao-mask', get_template_directory_uri().'/js/mask-config.js', array(), '1.0', true);
    
}
add_action('wp_enqueue_scripts', 'load_scripts');    

//Função de Configuração do Tema
function oliveirasombreadores_config(){
   //Registrando nossos menus
    register_nav_menus(
      array(
          'my_main_menu' => __('Main Menu', 'oliveirasombreadores')
      )
    );

    add_theme_support('post-thumbnails');
    add_theme_support('post-formats', array('video','image', 'gallery'));
    add_theme_support('title-tag');
    add_theme_support('custom-logo', array('height' => 72, 'width' => 356));
    add_theme_support( 'woocommerce' );

}
add_action('after_setup_theme','oliveirasombreadores_config',0);

// Post types
function meus_posts_types(){
    // Banners
    register_post_type('banners',
      array(
       'labels'           => array(
          'name'          => __('Banners'),
          'singular_name' => __('Banner')
          ),
       'public'           => true,
       'has_archive'      => true, 
       'menu_icon'        => 'dashicons-format-image',
       'supports'         =>  array('title','thumbnail'),
        )
  );
  register_post_type('servicos',
      array(
       'labels'           => array(
          'name'          => __('Serviços'),
          'singular_name' => __('Serviço')
          ),
       'taxonomies' => array('servicos-category'),
       'public'           => true,
       'has_archive'      => true, 
       'menu_icon'        => 'dashicons-hammer',
       'supports'         =>  array('title','editor','thumbnail','post-formats'),
        )
  );
  $labels = array(
        'name' => _x('Categorias', 'taxonomy general name'),
        'singular_name' => _x('Categoria', 'taxonomy singular name'),
        'search_items' =>  __('Procurar categoria'),
        'all_items' => __('Todos'),
        'edit_item' => __('Editar categoria'), 
        'update_item' => __('Editar categoria'),
        'add_new_item' => __('Adicionar categoria'),
        'new_item_name' => __('Nova categoria')
  );   

  register_taxonomy('servicos-category',array('servicos'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'query_var' => true,
        'show_in_nav_menus' => true,
        'rewrite' => array('slug' => 'categoria-servicos', 'with_front' => false),
  ));
}
add_action('init', 'meus_posts_types');

//Ajusta o tamanho do resumo dos textos do blog
add_filter('excerpt_length', 'custom_excerpt_length');
  function custom_excerpt_length($length) {
  return 15; //Nova quantidade de palavtas do excerpt
} 

add_filter('single_template', 'create_single_template');

function create_single_template( $template ) {
  global $post;

  $categories = get_the_category();
  // caso não tenhamos categoria retornamos o template default.
  if ( ! $categories )
      return $template; 

  //resgatando o post type
  $post_type = get_post_type( $post->ID );

  $templates = array();

  foreach ( $categories as $category ) {
      // adicionando templates por id e slug
      $templates[] = "single-{$post_type}-{$category->slug}.php";
      $templates[] = "single-{$post_type}-{$category->term_id}.php";
  }

  // adicionando os templates padrões
  $templates[] = "single-{$post_type}.php";
  $templates[] = 'single.php';
  $templates[] = 'singular.php';
  $templates[] = 'index.php';

  return locate_template( $templates );
}

/**
 *
 * Paginação utilizando a função paginate_links
 * @param  WP_Query $query Contém uma $query customizada
 *
 */
function wp_pagination( $query=null, $wpcpn_posts=null )
{
    global $wp_query;
    $query = $query ? $query : $wp_query;
    $big = 999999999;
    $max_num_pages = $query->max_num_pages;

    $paginate = paginate_links(
        array(
            'base'      => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'type'      => 'array',
            'total'     => $max_num_pages,
            'format'    => '?paged=%#%',
            'current'   => max( 1, get_query_var('paged') ),
            'prev_text' => __('&laquo;'),
            'next_text' => __('&raquo;'),
        )
    );
    if ( $max_num_pages > 1 && $paginate ) {
        echo '<ul class="pagination pagination-lg">';
        foreach ( $paginate as $page ) {
            echo '<li>' . $page . '</li>';
        }
        echo '</ul>';
    }
}

//Remove os atributos do produto
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

// Remove cart totals block
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals', 10 );

add_action( 'woocommerce_after_single_product_summary', 'woocommerce_template_single_rating', 5 );


//add_action('wp_ajax_minha_acao_ajax', 'funcao_da_minha_acao_ajax');​
add_action('wp_ajax_nopriv_acao_troca_produto', 'funcao_troca_produto');

function funcao_troca_produto() {

$id_produto = $_REQUEST['dados'];

$args = array(
   'post_type' => 'product',
   'p' => $id_produto
);

$query = new WC_Product_Query($args);

 foreach ($query->get_products() as $key => $p) {

  $image_id  = $p->get_image_id();
  $image_url = wp_get_attachment_image_url( $image_id, 'full' );
   
   $data .='<a href="'.get_permalink($p->get_id()).'">'; 
   $data .= '<div class="bloco__produto" style="background-image: url('.$image_url.');"></div>';
   $data .='</a>';

   $data .= '<p>Produto: '.$p->get_name().'</p>';

 }

echo json_encode($data, JSON_UNESCAPED_SLASHES);

wp_die();
}

