<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>


<div class="col-6 col-lg-4 col-xl-3">
	<div class="produtos__item">
		<div class="produtos__imagem">
			 <div class="produtos__imagem-child" style="background-image: url('<?php echo wp_get_attachment_url( $product->get_image_id() ); ?>')"></div>
			
		</div>
		<h3 class="produtos__nome">
			<?php print $product->get_name(); ?>
		</h3>
		<a class="button button__blue button__arrow" href="<?php print get_permalink( $product->get_id() ); ?>">
			Saiba mais
		</a>
	</div>
</div>

