<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>

<?
$image_id  = $product->get_image_id();
$image_url = wp_get_attachment_image_url( $image_id, 'full' );
?>

<div class="col-md-4">
 <div class="bloco__produtos">
     <figure>
     	<a href="<?= get_permalink($product->get_id());?>">
         <img src="<?= $image_url;?>" alt="<?= $product->get_name() ?>">
        </a>
     </figure>
     <h1><?= $product->get_name() ?></h1>
     <? the_excerpt(); ?>
     <div class="btn__ver-mais">
         <a href="<?= get_permalink($product->get_id());?>">VER MAIS</a>
     </div>
 </div>
</div>

