<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>

	
	

	<div class="summary entry-summary">
		
	</div>

	
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>

<section>
   <div class="banner__produtos"></div> 
</section>
<div class="produto">
    <div class="container">
        <div class="produto__main">
            <div class="row">
           <?php
             include get_template_directory().'/includes/menu-produtos.php';
           ?>
       
         <div class="col-md-9">
            <div class="">
                <h1 class="title"><? the_title(); ?></h1>
            </div>
                
            <div class="produto__infos">
                <div class="produto__imagem">
                    <img src="<? the_post_thumbnail_url( 'full' )?>" alt="">
                </div>
    
                <div class="produto__infos-main">
                    <?= $product->get_description(); ?>                
                </div>
            </div>
  
            <div class="galeria__produtos">
                <div class="row">
            <?
              //GALERIA DE PRODUTOS
              $attachment_ids = $product->get_gallery_image_ids();
              if($attachment_ids != NULL){
              foreach( $attachment_ids as $attachment_id ){ 
           ?>
                    <div class="col-md-6">
                        <figure>
                            <img src="<?= wp_get_attachment_url( $attachment_id )?>" alt="img-galeria"/> 
                        </figure>
                    </div>
            <?
               }
             }
            ?>
             </div>
            </div>

            <div class="produto__button-box">
                    <?php
            /**
             * Hook: woocommerce_single_product_summary.
             *
             * @hooked woocommerce_template_single_title - 5
             * @hooked woocommerce_template_single_rating - 10
             * @hooked woocommerce_template_single_price - 10
             * @hooked woocommerce_template_single_excerpt - 20
             * @hooked woocommerce_template_single_add_to_cart - 30
             * @hooked woocommerce_template_single_meta - 40
             * @hooked woocommerce_template_single_sharing - 50
             * @hooked WC_Structured_Data::generate_product_data() - 60
             */
            do_action( 'woocommerce_single_product_summary' );
            ?>
        </div>
                 </div>
            </div>
        </div>   
    </div>   
</div>



